#-*- coding: utf-8; -*-

require 'lib/mastermind'
require 'pp'

#0=Black, 1=Cyan, 2=Green, 3=Red, 4=Yellow, 5=White

describe "Code generator" do

  before do
    @random = mock("random")
  end

  it "should generate all black code for a random sequence of all 0s" do
    @random.should_receive(:next).exactly(4).times.with(no_args).and_return 0,0,0,0
    code = Mastermind::Code.generate_using(@random)
    # pp code.pegs
    code.mark(Mastermind::Code.new(:black, :black, :black, :black)).should be_win
  end

  it "should generate (Black Cyan Green Red) code for a sequence of 0, 1, 2, 3" do
    @random.should_receive(:next).exactly(4).times.with(no_args).and_return 0, 1, 2, 3
    code = Mastermind::Code.generate_using(@random)
    # pp code.pegs
    code.mark(Mastermind::Code.new(:black, :cyan, :green, :red)).should be_win
  end

end
